Date.prototype.format = function(format) {
    var date = {
        "M+": this.getMonth() + 1,
        "d+": this.getDate(),
        "h+": this.getHours(),
        "m+": this.getMinutes(),
        "s+": this.getSeconds(),
        "q+": Math.floor((this.getMonth() + 3) / 3),
        "S+": this.getMilliseconds()
    };
    if (/(y+)/i.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    for (var k in date) {
        if (new RegExp("(" + k + ")").test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1
                ? date[k] : ("00" + date[k]).substr(("" + date[k]).length));
        }
    }
    return format;
}


function checklogin(){
    var islogin = "logout";
    $.ajax({
        url:'/ajax/check_login.html',
        async:false,
        type:'GET',
        dataType:'Json',
        success:function(data) {
            islogin = data.status;
        }
    });

    if(islogin=='login'){
        return true;
    }
    var $form_modal = $('.cd-user-modal');
    var $form_login = $form_modal.find('#cd-login');
    var $form_signup = $form_modal.find('#cd-signup');
    var $form_modal_tab = $('.cd-switcher');
    var $tab_login = $form_modal_tab.children('li').eq(0).children('a');
    var $tab_signup = $form_modal_tab.children('li').eq(1).children('a');
    $form_modal.addClass('is-visible');
    $form_login.addClass('is-visible is-selected');
    $tab_login.addClass('selected');
    $form_signup.removeClass('is-selected');
    $tab_signup.removeClass('selected');
    return false;
}


function ajaxLogin(){
    var username = $('#signin-username').val();
    var password = $('#signin-password').val();
    if(username==null || username==''){
        $('#auto-close-dialogBox').dialogBox({
            autoHide: true,
            time: 1000,
            content: '<i class="fa fa-exclamation-triangle"></i>请输入手机号'
        });
        return false;
    }

    if(password==null || password==''){
        $('#auto-close-dialogBox').dialogBox({
            autoHide: true,
            time: 1000,
            content: '<i class="fa fa-exclamation-triangle"></i>请输入密码'
        });
        return false;
    }
    $.post('/ajax/login.html',{username:username,password:password},function(data){
        res = JSON.parse(data);
        if(res.result == 'success'){
            window.location.reload();
        }else{
            if(res.result == 'failed'){
                $('#auto-close-dialogBox').dialogBox({
                    autoHide: true,
                    time: 1000,
                    content: '<i class="fa fa-exclamation-triangle"></i>用户名或密码错误'
                });
            }

        }
    });
}

function ajaxReg(){
    var username = $('#signup-username').val();
    var password = $('#signup-password').val();
    var email = $('#signup-email').val();

    var regUsername = new RegExp("^[a-z]([a-z0-9])*[-_]?([a-z0-9]+)$","i");
    var regEmail = /^(\w)+(\.\w+)*@(\w)+((\.\w+)+)$/;

    if(regUsername==null || regUsername==''){
        alert('用户名不能为空');
        $('#signup-username').focus();
        return false;
    }

    if(!regUsername.test(username)){
        alert('用户名格式错误');
        $('#signup-username').focus();
        return false;
    }

    if(email!='' && !regEmail.test(email)){
        alert('Email格式错误');
        $('#signup-email').focus();
        return false;
    }

    if(username==null || username==''){
        alert('请输入用户名!');
    }

    if(password==null || password==''){
        alert('请输入密码!');
    }

    $.post('/ajax/reg.html',{username:username,password:password,email:email},function(data){
        res = JSON.parse(data);
        if(res.result == 'success'){
            window.location.reload();
        }else{
            alert(data);
        }
    });
}

function praise(comment_id){
    $.post('/ajax/praise_count.html',{comment_id:comment_id},function(data){
        res = JSON.parse(data);
        if(res.result == 'success'){
            var cpt = $('#comment-praise-count-'+comment_id);
            var count = Number(cpt.html());
            cpt.html(count+1);
            cpt.parent().addClass('current');
        }else{
            console.log(res.msg);
        }
    });
}

jQuery(document).ready(function($){
    var $form_modal = $('.cd-user-modal'),
        $form_login = $form_modal.find('#cd-login'),
        $form_signup = $form_modal.find('#cd-signup'),
        $form_modal_tab = $('.cd-switcher'),
        $tab_login = $form_modal_tab.children('li').eq(0).children('a'),
        $tab_signup = $form_modal_tab.children('li').eq(1).children('a'),
        $modal_header = $form_modal.find('.modal-header'),
        $mod_colse = $modal_header.find('.close');

    $mod_colse.on('click',function(){
        $form_modal.removeClass('is-visible');
    });

    //¹Ø±Õµ¯³ö´°¿Ú
    $('.cd-user-modal').on('click', function(event){
        if( $(event.target).is($form_modal) || $(event.target).is('.cd-close-form') ) {
            $form_modal.removeClass('is-visible');
        }
    });
    //Ê¹ÓÃEsc¼ü¹Ø±Õµ¯³ö´°¿Ú
    $(document).keyup(function(event){
        if(event.which=='27'){
            $form_modal.removeClass('is-visible');
        }
    });

    //ÇÐ»»±íµ¥
    //$form_modal_tab.on('click', function(event) {
    //    event.preventDefault();
    //    ( $(event.target).is( $tab_login ) ) ? login_selected() : signup_selected();
    //});

    function login_selected(){
        $tab_login.addClass('selected');
        $form_login.addClass('is-selected');
        $form_signup.removeClass('is-selected');
        $tab_login.addClass('selected');
        $tab_signup.removeClass('selected');
    }

    function signup_selected(){
        $form_login.removeClass('is-selected');
        $form_signup.addClass('is-selected');
        $tab_login.removeClass('selected');
        $tab_signup.addClass('selected');
    }

});


//credits http://css-tricks.com/snippets/jquery/move-cursor-to-end-of-textarea-or-input/
jQuery.fn.putCursorAtEnd = function() {
    return this.each(function() {
        // If this function exists...
        if (this.setSelectionRange) {
            // ... then use it (Doesn't work in IE)
            // Double the length because Opera is inconsistent about whether a carriage return is one character or two. Sigh.
            var len = $(this).val().length * 2;
            this.setSelectionRange(len, len);
        } else {
            // ... otherwise replace the contents with itself
            // (Doesn't work in Google Chrome)
            $(this).val($(this).val());
        }
    });
};